/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.nat;

import java.io.IOException;
import java.net.InetAddress;
import net.sourceforge.peers.nat.PeerManager;
import net.sourceforge.peers.nat.Server;
import org.w3c.dom.Document;

public class Client {
    private Server server;
    private PeerManager peerManager;

    public Client(String email, String localInetAddress, int localPort) {
        try {
            InetAddress localAddress = InetAddress.getByName(localInetAddress);
            this.server = new Server(localAddress, localPort);
            this.peerManager = new PeerManager(localAddress, localPort);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.server.update(email);
        Document document = this.server.getPeers(email);
        this.peerManager.setDocument(document);
        this.peerManager.start();
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.err.println("usage: java ... <email> <localAddress> <localPort>");
            System.exit(1);
        }
        new Client(args[0], args[1], Integer.parseInt(args[2]));
    }
}

